// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionSimple.h"
#include "flora.h"

#if CELESTIAL
  varying highp vec3 bgp;
  #define np normalize(bgp)
  
  highp vec3 sunmoon(vec3 color, float a){
    #ifdef dynamic
    highp float cel = length(np-a*sunpos);
    vec3 pos = sunpos*a;
    highp float mu = smoothstep(.9,.0,cel)*pow(dd*1.2+ssd*.9,3.)*pow(pos.y*.5+.5,.5);
    if(bgp.y>0. && cel<.03)color = skh*1.6;
    #else
    highp float cel = length(np-vec3(.5,0.,0.));
    highp float mu = smoothstep(.9,.0,cel)*pow(dd*ssd*1.3,.5);
    #endif
    if(cel<.9)color = mix(color,mix(color,skh,.2)*1.2,mu);
    return color;
  }
  
#endif

void main()
{
#if CELESTIAL
  highp float skp = 1.-abs(np.y);
  float a = 1.;
  if(np.y<0.)skp *= 0.97;
  highp vec3 color = mix(skc,skh,sld);
  if(np.y<0.)color = mix(color,mix(mix(color,usk,ssd),skh,sline(.75+ssd*.1,1.)),ssd*(1.-rain));
  highp vec3 sunmoon = sunmoon(sunmoon(color,1.),-1.);
  color = mix(sunmoon,color,rain);
  #ifndef dynamic
   if(np.y>0.)a=0.;
  #endif
#else
  vec3 color = vec3(0.);
  float a = 0.;
#endif

	gl_FragColor = vec4(color,a);
}
